Ext.data.JsonP.sol_contract_DurationUtils({"tagname":"class","name":"sol.contract.DurationUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.contract.DurationUtils.js","href":"lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.0"],"elowf":true,"requires":["sol.common.DateUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"allUnits","tagname":"property","owner":"sol.contract.DurationUtils","id":"property-allUnits","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addUpdate","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-addUpdate","meta":{"private":true}},{"name":"adjustToRealMonthEnd","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-adjustToRealMonthEnd","meta":{"private":true}},{"name":"calcContract","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcContract","meta":{}},{"name":"calcContractEnd","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcContractEnd","meta":{"private":true}},{"name":"calcDuration","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcDuration","meta":{}},{"name":"calcLocalCurrencyAmount","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcLocalCurrencyAmount","meta":{}},{"name":"calcNextPossibleContractEnd","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcNextPossibleContractEnd","meta":{"private":true}},{"name":"calcReminderDate","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcReminderDate","meta":{"private":true}},{"name":"calcRowTotal","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcRowTotal","meta":{}},{"name":"calcTerminationDateFixed","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcTerminationDateFixed","meta":{"private":true}},{"name":"calcTerminationDateFromNow","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-calcTerminationDateFromNow","meta":{"private":true}},{"name":"clearContractEnd","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-clearContractEnd","meta":{"private":true}},{"name":"getBaseCurrency","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-getBaseCurrency","meta":{}},{"name":"getEndOfDate","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-getEndOfDate","meta":{}},{"name":"getKwlKey","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-getKwlKey","meta":{}},{"name":"getSmallestUnitString","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-getSmallestUnitString","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isoToMoment","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-isoToMoment","meta":{"private":true}},{"name":"momentToIso","tagname":"method","owner":"sol.contract.DurationUtils","id":"method-momentToIso","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.contract.DurationUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.contract.DurationUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils' target='_blank'>lib_sol.contract.DurationUtils.js</a></div></pre><div class='doc-contents'><p>Helper functions for contracts</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-allUnits' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-property-allUnits' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-property-allUnits' class='name expandable'>allUnits</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;y&quot;, &quot;hy&quot;, &quot;Q&quot;, &quot;M&quot;, &quot;w&quot;, &quot;d&quot;]</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addUpdate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-addUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-addUpdate' class='name expandable'>addUpdate</a>( <span class='pre'>tplSord, updates, update</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Add update ...</div><div class='long'><p>Add update</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Template Sord</p>\n</div></li><li><span class='pre'>updates</span> : Array<div class='sub-desc'><p>Updates array</p>\n</div></li><li><span class='pre'>update</span> : Object<div class='sub-desc'><p>Update</p>\n</div></li></ul></div></div></div><div id='method-adjustToRealMonthEnd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-adjustToRealMonthEnd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-adjustToRealMonthEnd' class='name expandable'>adjustToRealMonthEnd</a>( <span class='pre'>adjustMoment, indicatorMoment, indicatorUnits</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjustMoment</span> : Moment<div class='sub-desc'><p>Adjust moment</p>\n</div></li><li><span class='pre'>indicatorMoment</span> : Moment<div class='sub-desc'><p>Indicator moment</p>\n</div></li><li><span class='pre'>indicatorUnits</span> : String<div class='sub-desc'><p>Indicator units</p>\n</div></li></ul></div></div></div><div id='method-calcContract' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcContract' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcContract' class='name expandable'>calcContract</a>( <span class='pre'>tplSord, updates</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates contract data ...</div><div class='long'><p>Calculates contract data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Template Sord</p>\n</div></li><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Template Sord</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>updates Updates</p>\n</div></li></ul></div></div></div><div id='method-calcContractEnd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcContractEnd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcContractEnd' class='name expandable'>calcContractEnd</a>( <span class='pre'>tplSord, updates, additionalShiftCounter</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Tempate Sord</p>\n</div></li><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Updates</p>\n</div></li><li><span class='pre'>additionalShiftCounter</span> : Number<div class='sub-desc'><p>Additional shift counter</p>\n</div></li></ul></div></div></div><div id='method-calcDuration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcDuration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcDuration' class='name expandable'>calcDuration</a>( <span class='pre'>startDateIso, endDateIso, unit</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates a duration ...</div><div class='long'><p>Calculates a duration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startDateIso</span> : String<div class='sub-desc'><p>Start date</p>\n</div></li><li><span class='pre'>endDateIso</span> : String<div class='sub-desc'><p>End date</p>\n</div></li><li><span class='pre'>unit</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-calcLocalCurrencyAmount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcLocalCurrencyAmount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcLocalCurrencyAmount' class='name expandable'>calcLocalCurrencyAmount</a>( <span class='pre'>amount, exchangeRate</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates the local currency amount ...</div><div class='long'><p>Calculates the local currency amount</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>amount</span> : Number<div class='sub-desc'><p>Amount</p>\n</div></li><li><span class='pre'>exchangeRate</span> : Number<div class='sub-desc'><p>Exchange rate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-calcNextPossibleContractEnd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcNextPossibleContractEnd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcNextPossibleContractEnd' class='name expandable'>calcNextPossibleContractEnd</a>( <span class='pre'>tplSord, updates, additionalShiftCounter</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Tempate Sord</p>\n</div></li><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Updates</p>\n</div></li><li><span class='pre'>additionalShiftCounter</span> : Number<div class='sub-desc'><p>Additional shift counter</p>\n</div></li></ul></div></div></div><div id='method-calcReminderDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcReminderDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcReminderDate' class='name expandable'>calcReminderDate</a>( <span class='pre'>tplSord, updates</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Tempate Sord</p>\n</div></li><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Updates</p>\n</div></li></ul></div></div></div><div id='method-calcRowTotal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcRowTotal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcRowTotal' class='name expandable'>calcRowTotal</a>( <span class='pre'>startDateIso, endDateIso, singleAmount, unit</span> ) : Decimal<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates the row total ...</div><div class='long'><p>Calculates the row total</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startDateIso</span> : String<div class='sub-desc'><p>Start date</p>\n</div></li><li><span class='pre'>endDateIso</span> : String<div class='sub-desc'><p>End date</p>\n</div></li><li><span class='pre'>singleAmount</span> : Decimal<div class='sub-desc'><p>Single amount</p>\n</div></li><li><span class='pre'>unit</span> : String<div class='sub-desc'><p>Unit</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Decimal</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-calcTerminationDateFixed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcTerminationDateFixed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcTerminationDateFixed' class='name expandable'>calcTerminationDateFixed</a>( <span class='pre'>tplSord, updates</span> ) : Moment<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Template Sord</p>\n</div></li><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Updates</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Moment</span><div class='sub-desc'><p>Next possible termination date</p>\n</div></li></ul></div></div></div><div id='method-calcTerminationDateFromNow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-calcTerminationDateFromNow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-calcTerminationDateFromNow' class='name expandable'>calcTerminationDateFromNow</a>( <span class='pre'>tplSord, updates</span> ) : Moment<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Tempate Sord</p>\n</div></li><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Updates</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Moment</span><div class='sub-desc'><p>Next possible termination date</p>\n</div></li></ul></div></div></div><div id='method-clearContractEnd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-clearContractEnd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-clearContractEnd' class='name expandable'>clearContractEnd</a>( <span class='pre'>tplSord</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Clears the contract end date ...</div><div class='long'><p>Clears the contract end date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tplSord</span> : Object<div class='sub-desc'><p>Tempate Sord</p>\n</div></li></ul></div></div></div><div id='method-getBaseCurrency' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-getBaseCurrency' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-getBaseCurrency' class='name expandable'>getBaseCurrency</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the base currency ...</div><div class='long'><p>Returns the base currency</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Base currency</p>\n</div></li></ul></div></div></div><div id='method-getEndOfDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-getEndOfDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-getEndOfDate' class='name expandable'>getEndOfDate</a>( <span class='pre'>date, unit</span> ) : Date<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the \"end of\" date ...</div><div class='long'><p>Returns the \"end of\" date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : Date<div class='sub-desc'><p>Date</p>\n</div></li><li><span class='pre'>unit</span> : String<div class='sub-desc'><p>Unit</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Date</span><div class='sub-desc'><p>End of date</p>\n</div></li></ul></div></div></div><div id='method-getKwlKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-getKwlKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-getKwlKey' class='name expandable'>getKwlKey</a>( <span class='pre'>str, separator</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the keyword list key ...</div><div class='long'><p>Returns the keyword list key</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>String</p>\n</div></li><li><span class='pre'>separator</span> : String<div class='sub-desc'><p>Separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSmallestUnitString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-getSmallestUnitString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-getSmallestUnitString' class='name expandable'>getSmallestUnitString</a>( <span class='pre'>unitStrings</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the smallest duration unit ...</div><div class='long'><p>Returns the smallest duration unit</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>unitStrings</span> : Array<div class='sub-desc'><p>Units strings</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isoToMoment' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-isoToMoment' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-isoToMoment' class='name expandable'>isoToMoment</a>( <span class='pre'>isoDate</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts an ISO date to a moment date ...</div><div class='long'><p>Converts an ISO date to a moment date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDate</span> : String<div class='sub-desc'><p>ISO date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Moment date</p>\n</div></li></ul></div></div></div><div id='method-momentToIso' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.DurationUtils'>sol.contract.DurationUtils</span><br/><a href='source/lib_sol.contract.DurationUtils.html#sol-contract-DurationUtils-method-momentToIso' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.DurationUtils-method-momentToIso' class='name expandable'>momentToIso</a>( <span class='pre'>mom</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts a moment date to an ISO date ...</div><div class='long'><p>Converts a moment date to an ISO date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mom</span> : Object<div class='sub-desc'><p>Moment date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ISO date</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"elowf":true,"singleton":true}});